	% Example 9.2
	clear all
	close all
	% Frn Example 5.8 Linear-phase, equiripple lowpass FIR 
	
	wT = [0.3 0.6]*pi; 					% Band edges
	b = [1 0];							% Gain in the bands
	d = [0.02 0.0025]; 					% Acceptable deviations
	[N, Be, D, W] = L_PHASE_LP_FIR_ORDER(wT, d);
	N = 16 								% Try different filter orders
	Type = 'm';
	[h, Err] = REMEZ_FIR(N, Be, D, W, Type);
	h;
	hn = (1/(1+Err))*h					% Normalize the max gain to 1
	disp(sprintf('Err = %2.8f', Err))	% Max error function
	Amax = 20*log10((1+Err*min(W))/(1-Err*min(W)));
	disp(sprintf('Amax = %2.6f dB', Amax))
	Amin = 20*log10((1+Err*max(W))/Err*max(W));
	disp(sprintf('Amin = %2.3f dB', Amin))
	
	wT = linspace(0, pi, 1000);		% wT axis 0 to  rad
	H = freqz(hn, 1, wT);			% Frequency response
	Mag = H_2_MAG(H);				% Magnitude response [dB]
	Phase = angle(H);				% Phase response [rad]
	%	gd = grpdelay(hn, 1, wT);	% Group delay [T]
	
	opt ='mag';
	PLOT_Mag_PZ_h_FIR(wT, Mag, hn, Be, D, d, opt)
	
	% =========================
	
	[b, a] = prony(hn, 11, 2);
	Z = roots(b);
	P = roots(a); P = [P; zeros(1,length(Z)-length(P))'];
	G = real(prod(1-P)/prod(1-Z));
	figure(2)
	PLOT_PZ_Z(Z, P)
	figure(3)
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	PLOT_ATT_TG_Z(Att, Taug, wT, 80, 40)
	
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 10.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(0.7, -8.1,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
